/**
* \file: FeatureDiscoveryImpl.h
*
* \version: 0.1
*
* \release: $Name:$
*
* Provides interface to the internal implementation of the Feature Discovery.
*
* \component: Unified SPI
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_FEATURE_DISCOVERY_IMPL_H_
#define USPI_FEATURE_DISCOVERY_IMPL_H_


#include <pthread_adit.h>

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/epoll.h>

#include <memory>
#include <condition_variable>
#include <mutex>

#include "FeatureDiscoveryTypes.h"
#include "IFeatureDiscovery.h"

#include <uspi/deviceDetector.h>


namespace adit { namespace uspi {


class FeatureDiscoveryImpl : public IDeviceEventHandler
{
public:
    FeatureDiscoveryImpl(void* inContext, IFeatureDiscoveryCb* inCallbacks, uint32_t inMask);
    virtual ~FeatureDiscoveryImpl();

    DiscoveryError start();
    DiscoveryError stop();

private:
    /// This method is called when a new device matching the mask set during
    /// init is changing its state.
    void handleDeviceEvent(DeviceInfo& devInfo, int32_t eventType, int32_t eventMask);

    void* mContext;
    IFeatureDiscoveryCb* mICallbacks;

    int32_t SetThreadParam(pthread_t inThreadId, std::string inThreadName, int32_t inThreadPrio);

    static void* ImplThread(void* context);

    /* ID of the EventThread */
    pthread_t mImplThreadId;

    std::condition_variable mImplThreadCondVar;
    std::mutex mImplThreadMutex;

    bool mRunning;

    static int32_t epollCallback(void* context);
    int32_t epollRegisterEvent(int32_t epollFd);
    int32_t epollEventWait(int32_t epollFd, struct epoll_event* epollEvents);

    uint32_t mMask;

    std::unique_ptr<adit::uspi::DeviceDetector> mDeviceDetector;
};


} } /* namespace adit { namespace uspi { */


#endif /* USPI_FEATURE_DISCOVERY_IMPL_H_ */
